
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        .add-item-form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            max-width: 600px;
            margin: auto;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-top: 50px;
            display: flex;
            flex-direction: column;
        }

        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            color: #212529;
        }

        input[type="text"],
        input[type="number"],
        select {
            /* width: 100%; */
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 6px;
            margin-top: 5px;
        }

        button {
            margin-top: 20px;
            padding: 10px 25px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
        }

        button:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>
    
    <?php echo $__env->make('dashboard.nav.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container mt-5">
    <h2 class="mb-4">تعديل المنتج</h2>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form class="add-item-form" method="POST" action="<?php echo e(route('items.update', $item->id)); ?>">
         <?php if(session('success')): ?>
            <div class="success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="error">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p><?php echo e($error); ?></p>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

            <label class="form-label">الاسم</label>
            <input type="text" name="name" class="form-control" value="<?php echo e(old('name', $item->name)); ?>" required>

            <label class="form-label">وصف الصنف(إختياري)</label>
            <input type="text" name="description" class="form-control" value="<?php echo e(old('description', $item->description)); ?>">

            <label class="form-label">السعر صغير</label>
            <input type="number" name="priceS" step="0.01" class="form-control" value="<?php echo e(old('priceS', $item->priceS)); ?>">

            <label class="form-label">السعر وسط</label>
            <input type="number" name="priceM" step="0.01" class="form-control" value="<?php echo e(old('priceM', $item->priceM)); ?>">

            <label class="form-label">السعر كبير</label>
            <input type="number" name="priceL" step="0.01" class="form-control" value="<?php echo e(old('priceL', $item->priceL)); ?>">

            <label class="form-label">القسم</label>
            <select name="category_id" class="form-select">
                <option value="">-- اختر القسم --</option>
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>" <?php echo e($item->category_id == $category->id ? 'selected' : ''); ?>>
                        <?php echo e($category->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>

        <button type="submit" class="btn btn-primary">تحديث</button>
    </form>
</div>

</body>
</html><?php /**PATH E:\xampp\htdocs\menu-project\resources\views/dashboard/edit_items.blade.php ENDPATH**/ ?>