<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="منيو الكتروني لمطعم او كافيه <?php echo e($restaurant->name); ?>.">
    <meta name="keywords" content="منيو مطعم <?php echo e($restaurant->name); ?>, منيو كافيه <?php echo e($restaurant->name); ?>, مطعم, منيو الكتروني <?php echo e($restaurant->name); ?> ,<?php echo e($restaurant->name); ?>">
    <meta name="robots" content="index, follow">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . $restaurant->logo)); ?>">
    <title><?php echo e($restaurant->name); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('css/menu.css')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700&display=swap" rel="stylesheet">
  
</head>
<body>
  <div style="width: 100%;display: flex;justify-content: space-between;">
    <svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75" fill="none">
      <path d="M46 56V16H11" stroke="#DDB84A"/>
      <path d="M51 62V11H7" stroke="#DDB84A"/>
      <path d="M56 68V6H4" stroke="#DDB84A"/>
      <path d="M61 75V1H0" stroke="#DDB84A"/>
    </svg>
    <svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75" fill="none">
      <path d="M16 56V16H51" stroke="#DDB84A"/>
      <path d="M11 62V11H55" stroke="#DDB84A"/>
      <path d="M6 68V6H58" stroke="#DDB84A"/>
      <path d="M0.999999 75V1H62" stroke="#DDB84A"/>  
    </svg>
  </div>
    <div class="container">
        <div class="border-top"></div>
        <div class="header">
            <?php if($restaurant && $restaurant->logo): ?>
                <img id="logo-img" src="<?php echo e(asset('storage/' . $restaurant->logo)); ?>" alt="Logo" style="height: <?php echo e($restaurant->logo_size); ?>px; margin:auto;">
            <?php elseif($restaurant): ?>
                <h1><?php echo e($restaurant->name); ?></h1>
            <?php endif; ?>
            <div style="height: 32px;display: flex;justify-content: center;align-items: center; overflow: hidden;">
              <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="300" height="307" viewBox="0 0 4503 307" fill="none">
                <rect y="307" width="307" height="4503" transform="rotate(-90 0 307)" fill="url(#pattern0_922_859)"/>
                <defs>
                <pattern id="pattern0_922_859" patternContentUnits="objectBoundingBox" width="1" height="1">
                <use xlink:href="#image0_922_859" transform="matrix(0.0246914 0 0 0.0016835 -4.62963 0)"/>
                </pattern>
                <image id="image0_922_859" width="420" height="594" preserveAspectRatio="none" xlink:href="data:image/png;base64,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"/>
                </defs> 
              </svg>
            </div>
            <div class="section-title">قسم <?php echo e($categoryName); ?></div>
        </div>

        <div class="navigation">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <a href="<?php echo e(route('menu.category', urlencode($cat->name))); ?>"
                class="nav-button <?php echo e($cat->name == $categoryName ? 'active' : ''); ?>">
                    <?php echo e($cat->name); ?>

                </a>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>


        <div class="menu-table-container">
            <table class="menu-table">
                <thead>
                    <tr>
                        <th><div class="typewriter">الصنف</div></th>
                        <th><div class="typewriter">S</div></th>
                        <th><div class="typewriter">M</div></th>
                        <th><div class="typewriter">L</div></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><div class="typewriter"><?php echo e($item->name); ?> <p style="font-size: 10px;"><?php echo e($item->description); ?></p></div></td>
                            <td><div class="typewriter" style="font-size: 12px;"><?php echo e($item->priceS ?? '-'); ?></div></td>
                            <td><div class="typewriter" style="font-size: 12px;"><?php echo e($item->priceM ?? '-'); ?></div></td>
                            <td><div class="typewriter" style="font-size: 12px;"><?php echo e($item->priceL ?? '-'); ?></div></td>
                        </tr>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4">لا توجد عناصر في هذا القسم</td>
                        </tr>
                    <?php endif; ?>
                </tbody>


            </table>
        </div>
        <div class="border-bottom"></div>
    </div>

  <div style="width: 100%;display: flex;justify-content: space-between; transform: rotateX(180deg);">
    <svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75" fill="none">
      <path d="M46 56V16H11" stroke="#DDB84A"/>
      <path d="M51 62V11H7" stroke="#DDB84A"/>
      <path d="M56 68V6H4" stroke="#DDB84A"/>
      <path d="M61 75V1H0" stroke="#DDB84A"/>
    </svg>
    <svg xmlns="http://www.w3.org/2000/svg" width="62" height="75" viewBox="0 0 62 75" fill="none">
      <path d="M16 56V16H51" stroke="#DDB84A"/>
      <path d="M11 62V11H55" stroke="#DDB84A"/>
      <path d="M6 68V6H58" stroke="#DDB84A"/>
      <path d="M0.999999 75V1H62" stroke="#DDB84A"/>  
    </svg>
  </div>


  <script>
      document.addEventListener("DOMContentLoaded", function () {
          const elements = document.querySelectorAll('.typewriter');

          elements.forEach(el => {
              el.addEventListener('animationend', function () {
                  el.style.whiteSpace = 'normal';
              });
          });
      });
  </script>

</body>
</html>


<?php /**PATH E:\xampp\htdocs\menu-project\resources\views/welcome.blade.php ENDPATH**/ ?>