<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\RestaurantController;
use App\Models\Category;

Route::get('/', function () {
    if (!Category::exists()) {
        return response('لا يوجد اقسام ');
    }else{
        $firstCategory = \App\Models\Category::first();
        return redirect()->route('menu.category', urlencode($firstCategory->name ?? ''));
    }
});


Route::get('/menu/{category}', [\App\Http\Controllers\MenuController::class, 'showCategory'])->name('menu.category');
Route::get('/Settings', [\App\Http\Controllers\DashboardController::class, 'Settings'])->name('settings');


// صفحة تسجيل المطعم
Route::get('/register-restaurant', [RestaurantController::class, 'showRegisterForm'])->name('restaurant.register');
Route::post('/register-restaurant', [RestaurantController::class, 'register'])->name('restaurant.store');


// صفحة الداشبورد
use Illuminate\Support\Facades\Auth;
use App\Models\Restaurant;
use App\Http\Controllers\DashboardController;

Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

// صفحة تسجيل الدخول
// Route::get('/login', function () {
//     return view('auth.login'); // لو عندك صفحة تسجيل دخول مخصصة
// })->name('login');

use App\Http\Controllers\RestaurantAuthController;

Route::get('/login', [RestaurantAuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [RestaurantAuthController::class, 'login'])->name('login.submit');
Route::post('/logout', [RestaurantAuthController::class, 'logout'])->name('logout');


Route::post('/items', [DashboardController::class, 'store'])->name('items.store');
Route::post('/categories', [DashboardController::class, 'categories_store'])->name('categories.store');


Route::get('/add_items', [DashboardController::class, 'add_items'])->name('add_items');
Route::get('/add_categories', [DashboardController::class, 'add_categories'])->name('add_categories');


Route::get('/items/{item}/edit', [DashboardController::class, 'edit'])->name('items.edit');
Route::put('/items/{item}', [DashboardController::class, 'update'])->name('items.update');

Route::get('/categories/{item}/edit', [DashboardController::class, 'categories_edit'])->name('categories.edit');
Route::put('/categories/{item}', [DashboardController::class, 'categories_update'])->name('categories.update');

Route::put('/Settings', [DashboardController::class, 'Settings_update'])->name('settings.update');


Route::delete('/items/{item}', [DashboardController::class, 'destroy'])->name('items.destroy');
Route::delete('/categories/{category}', [DashboardController::class, 'categories_destroy'])->name('categories.destroy');
