{{-- <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet"> --}}
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style>
        .add-item-form {
            background-color: #ffffff;
            padding: 20px;
            border-radius: 10px;
            max-width: 600px;
            margin: auto;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-top: 50px;
            display: flex;
            flex-direction: column;
        }

        label {
            display: block;
            margin-top: 15px;
            font-weight: bold;
            color: #212529;
        }

        input[type="text"],
        input[type="number"],
        select {
            /* width: 100%; */
            padding: 10px;
            border: 1px solid #ced4da;
            border-radius: 6px;
            margin-top: 5px;
        }

        button {
            margin-top: 20px;
            padding: 10px 25px;
            background-color: #28a745;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
        }

        button:hover {
            background-color: #218838;
        }
        .delete-button {
            background-color: #e3342f;
            
        }

        .delete-button:hover {
            background-color: #cc1f1a;
        }
    </style>
</head>
<body>
    
    @include('dashboard.nav.nav')

<div class="container mt-5">
    <h2 class="mb-4">تعديل القسم</h2>

    <form action="{{ route('categories.destroy', $category->id) }}" method="POST" style="display: inline-block;" onsubmit="return confirm('هل أنت متأكد من حذف هذا القسم');">
        @csrf
        @method('DELETE')
        <button type="submit" class="delete-button">حذف</button>
    </form>

    

    <form class="add-item-form" method="POST" action="{{ route('categories.update', $category->id) }}">
        @if (session('success'))
            <div class="success">{{ session('success') }}</div>
        @endif
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        @csrf
        @method('PUT')

            <label for="name" class="form-label">الاسم</label>
            <input type="text" name="name" class="form-control" value="{{ old('name', $category->name) }}" required>

        <button type="submit" class="btn btn-primary">تحديث</button>
    </form>
</div>

</body>
</html>