<?php
// اسم الملف RestaurantCheck.php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Restaurant;

class RestaurantCheck
{
    public function handle(Request $request, Closure $next)
    {

        //  \Log::info('RestaurantCheck middleware triggered'); // ← دي بتسجل في اللوج
        $restaurantExists = Restaurant::exists();

        if (!$restaurantExists) {
            return redirect()->route('restaurant.register');
        }

        if (!Auth::check()) {
            return redirect()->route('login');
        }

        return $next($request);
    }
}
