<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Restaurant;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;



class RestaurantController extends Controller
{

    public function showRegisterForm()
    {
        if (!Restaurant::exists()) {
            return view('restaurant.register');
        }elseif (!Auth::check()){
            return redirect()->route('login');
        }
        
    }

    public function register(Request $request)
    {

        $request->validate([
            'name' => 'required|string',
            'logo' => 'nullable|image',
            'logo_size' => 'required|numeric|min:1|max:100',
            'username' => 'required|string|unique:restaurants',
            'password' => 'required|string|min:3',
        ]);
        // dd($request->all());


        $logoPath = null;
        if ($request->hasFile('logo')) {
            $logoPath = $request->file('logo')->store('logos', 'public');
        }


        Restaurant::create([
            'name' => $request->name,
            'logo' => $logoPath,
            'logo_size' => $request->logo_size,
            'username' => $request->username,
            'password' => Hash::make($request->password),
        ]);

        return redirect()->route('login')->with('success', 'تم التسجيل بنجاح! سجّل الدخول الآن.');
    }

}
