

<?php $__env->startSection('title', 'تعديل صنف'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-100 py-10 px-6">
    <div class="max-w-3xl mx-auto bg-white rounded-2xl shadow-lg p-8">

        <h2 class="text-2xl font-bold text-gray-800 mb-6 text-center border-b pb-3">
            ✏️ تعديل المنتج
        </h2>

        
        <?php if(session('success')): ?>
            <div class="mb-4 p-3 bg-green-100 text-green-700 rounded-lg text-center">
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="mb-4 p-3 bg-red-100 text-red-700 rounded-lg">
                <ul class="list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('items.update', $item->id)); ?>" method="POST" enctype="multipart/form-data" class="space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📸 صورة المنتج</label>
                <?php if($item->image_url): ?>
                    <img src="<?php echo e(asset('storage/' . $item->image_url)); ?>" alt="Current Image" class="w-32 h-32 object-cover rounded-lg mb-3 border">
                <?php endif; ?>
                <input type="file" name="image" accept="image/*"
                       class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
            </div>

            
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📝 الاسم</label>
                <input type="text" name="name" value="<?php echo e(old('name', $item->name)); ?>" required
                       class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
            </div>

            
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📄 وصف الصنف (اختياري)</label>
                <textarea name="description" rows="2"
                          class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500"><?php echo e(old('description', $item->description)); ?></textarea>
            </div>


            <!-- نوع السعر -->
            <div class="mb-4">
                <label class="block font-semibold text-gray-700 mb-2">نوع السعر:</label>
                <div class="flex items-center gap-6">
                    <label class="flex items-center space-x-2">
                        <input type="radio" name="price_type" value="single" class="toggle-price"
                            <?php echo e(old('price_type', $item->price && !$item->priceS ? 'single' : '') == 'single' ? 'checked' : ''); ?>>
                        <span>سعر واحد</span>
                    </label>
                    <label class="flex items-center space-x-2">
                        <input type="radio" name="price_type" value="multiple" class="toggle-price"
                            <?php echo e(old('price_type', $item->priceS ? 'multiple' : '') == 'multiple' ? 'checked' : ''); ?>>
                        <span>أكثر من سعر</span>
                    </label>
                </div>
            </div>

            <!-- حقل السعر الواحد -->
            <div id="single-price-field" class="mb-4 <?php echo e($item->priceS ? 'hidden' : ''); ?>">
                <label class="block font-semibold text-gray-700 mb-2">💵 السعر</label>
                <input id="price" type="number" step="0.01" name="price"
                    value="<?php echo e(old('price', $item->price)); ?>"
                    class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
            </div>

            <!-- الحقول المتعددة -->
            <div id="multiple-price-fields" class="grid grid-cols-1 sm:grid-cols-3 gap-4 <?php echo e(!$item->priceS ? 'hidden' : ''); ?>">
                <div>
                    <label class="block font-semibold text-gray-700 mb-1">💰 السعر صغير</label>
                    <input type="number" name="priceS" step="0.01"
                        value="<?php echo e(old('priceS', $item->priceS)); ?>"
                        class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block font-semibold text-gray-700 mb-1">💰 السعر وسط</label>
                    <input type="number" name="priceM" step="0.01"
                        value="<?php echo e(old('priceM', $item->priceM)); ?>"
                        class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                </div>
                <div>
                    <label class="block font-semibold text-gray-700 mb-1">💰 السعر كبير</label>
                    <input type="number" name="priceL" step="0.01"
                        value="<?php echo e(old('priceL', $item->priceL)); ?>"
                        class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                </div>
            </div>


            
            <div>
                <label class="block font-semibold text-gray-700 mb-2">📂 القسم</label>
                <select name="category_id" required
                        class="w-full border border-gray-300 rounded-lg p-2 focus:ring-2 focus:ring-blue-500">
                    <option value="">-- اختر القسم --</option>
                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" <?php echo e($item->category_id == $category->id ? 'selected' : ''); ?>>
                            <?php echo e($category->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            
            <div class="text-center">
                <button type="submit"
                        class="bg-yellow-500 text-white px-6 py-2 rounded-lg shadow hover:bg-yellow-600 transition">
                    💾 تحديث المنتج
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const singleField = document.getElementById("single-price-field");
        const multipleFields = document.getElementById("multiple-price-fields");
        const radios = document.querySelectorAll(".toggle-price");

        radios.forEach(radio => {
            radio.addEventListener("change", function () {
                if (this.value === "single") {
                    singleField.classList.remove("hidden");
                    multipleFields.classList.add("hidden");
                } else {
                    singleField.classList.add("hidden");
                    multipleFields.classList.remove("hidden");
                }
            });
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.nav.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\menu-test\resources\views/dashboard/edit_items.blade.php ENDPATH**/ ?>