<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . $restaurant->logo)); ?>">
    <title><?php echo e($restaurant->name); ?></title>
    
    <!-- Google Fonts - Arabic -->
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700&display=swap" rel="stylesheet">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Font Awesome for icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <!-- Schema.org JSON-LD -->
    
    
    <style>
        /* Custom RTL and Arabic optimizations */
        * {
            font-family: 'Cairo', sans-serif;
            translate: 0.5s;
        }
        
        .fade-in {
            animation: fadeIn 0.5s ease-in;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .btn-press {
            transition: transform 0.1s ease;
        }
        
        .btn-press:active {
            transform: scale(0.95);
        }
        
        .cart-badge {
            animation: bounce 0.3s ease;
        }
        
        @keyframes bounce {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.2); }
        }
        
        .loading-placeholder {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: loading 1.5s infinite;
        }
        
        @keyframes loading {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
        
        .category-scroll {
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        
        .category-scroll::-webkit-scrollbar {
            display: none;
        }
        .offers {
            scrollbar-width: none;
            -ms-overflow-style: none;
        }
        .offers::-webkit-scrollbar {
            display: none;
        }
        body{
            background-color: <?php echo e($settings['background_color'] ?? '#f9fafb'); ?> !important;
        }
        .primary_color{
            background-color: <?php echo e($settings['primary_color'] ?? '#16a34a'); ?> !important;
        }
        .primary_color:hover{
            background-color: <?php echo e($settings['primary_hover'] ?? '#16a34a'); ?> !important;
        }
        .primary_color_hover:hover{
            color: <?php echo e($settings['primary_hover'] ?? '#16a34a'); ?> !important;
        }
        .Accent_color{
            background-color: <?php echo e($settings['accent_color'] ?? '#16a34a'); ?> !important;
        }
        .text-green-600{
            color: <?php echo e($settings['primary_color'] ?? '#16a34a'); ?> !important;
        }
        .border{
            border-color: <?php echo e($settings['border_color'] ?? '#16a34a'); ?> !important;
        }
        .border-hover:hover{
            border-color: <?php echo e($settings['primary_color'] ?? '#16a34a'); ?> !important;
        }
        .Text_dark{
            color: <?php echo e($settings['text_dark'] ?? '#111827'); ?> !important;
        }
        .Text_light{
            color: <?php echo e($settings['text_light'] ?? '#6b7280'); ?> !important;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <header class="Accent_color shadow-sm sticky top-0 z-40">
        <div class="max-w-4xl mx-auto px-4 py-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-reverse space-x-4">
                    <?php if($restaurant && $restaurant->logo): ?>
                        <img id="logo-img" src="<?php echo e(asset('storage/' . $restaurant->logo)); ?>" alt="Logo" style="height: <?php echo e($restaurant->logo_size); ?>px; margin:auto;">
                    <?php elseif($restaurant): ?>
                        <div class="w-12 h-12 primary_color rounded-full flex items-center justify-center">
                            <i class="fas fa-utensils text-white text-lg"></i>
                            
                        </div>
                        <div>
                            <h1 class="text-xl font-bold Text_dark" id="restaurant-name"><?php echo e($restaurant->name); ?></h1>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="flex items-center space-x-reverse space-x-2">
                    <button onclick="shareMenu()" class="p-2 Text_light primary_color_hover btn-press" aria-label="مشاركة القائمة">
                        <i class="fas fa-share-alt text-lg"></i>
                    </button>
                    <a href="tel:<?php echo e($restaurant->phone); ?>" class="primary_color text-white px-4 py-2 rounded-lg hover:bg-green-700 btn-press" id="phone-btn">
                        <i class="fas fa-phone ml-2"></i>
                        اتصل
                    </a>
                </div>
            </div>
        </div>
    </header>

    <!-- Banner Image -->
    <div class="relative h-48 bg-gradient-to-r from-green-600 to-green-700">
        <img src="<?php echo e(asset('storage/' . $restaurant->Banner)); ?>" 
             alt="مطعم الوادي" 
             class="w-full h-full object-cover opacity-80 loading-placeholder"
             loading="lazy">
        <div class="absolute inset-0 bg-black bg-opacity-20"></div>
    </div>

    <?php if($offers->count() > 0): ?>
        <section class=" py-10">
            <div class="container mx-auto px-4">
                <!-- العنوان -->
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-2xl font-bold Text_dark flex items-center gap-2">
                        <span class="text-3xl"><img _ngcontent-ng-c4072257393="" src="https://fonts.gstatic.com/s/e/notoemoji/latest/1f525/512.gif" alt="🔥" width="32" height="32"></span> العروض
                    </h2>
                </div>

                <!-- سطر العروض -->
                <div class="flex offers space-x-4 space-x-reverse overflow-x-auto pb-4 scrollbar-thin scrollbar-thumb-gray-700 scrollbar-track-gray-800 snap-x snap-mandatory">
                    <?php $__currentLoopData = $offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="Accent_color rounded-xl overflow-hidden shadow-md hover:shadow-lg transition relative group flex-shrink-0 w-64 snap-start">
                            
                            <?php if($offer->is_featured): ?>
                                <span class="absolute top-3 left-3 bg-red-500 text-white text-xs font-bold px-3 py-1 rounded-full shadow-md z-10 items-center flex  ">
                                    عرض مميز
                                    <img _ngcontent-ng-c4072257393="" src="https://fonts.gstatic.com/s/e/notoemoji/latest/1f525/512.gif" alt="🔥" width="20" height="20">
                                </span>
                            <?php endif; ?>

                            
                            <div class="relative">
                                <img src="<?php echo e(asset('storage/' . $offer->image)); ?>" 
                                    alt="<?php echo e($offer->title); ?>" 
                                    class="w-full h-40 object-cover rounded-t-xl group-hover:opacity-90 transition">
                            </div>

                            
                            <div class="p-4 Text_dark">
                                <h3 class="text-sm font-semibold mb-2 leading-5 line-clamp-2">
                                    <?php echo e($offer->title); ?>

                                </h3>
                                <p class="Text_light text-xs mb-3 leading-4 line-clamp-3">
                                    <?php echo e($offer->description); ?>

                                </p>
                                <div class="flex items-center justify-between">
                                    <span class="text-lg font-bold Text_dark">
                                        <?php echo e($offer->price); ?> <?php echo e($restaurant->currency); ?>

                                    </span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </section>
    <?php endif; ?>



    <!-- Search Bar -->
    <form onsubmit="return false;">
        <div class="max-w-4xl mx-auto px-4 py-4">
            <div class="relative">
                <input name="search" type="text" 
                    id="search-input" 
                    placeholder="ابحث في القائمة..." 
                    class="w-full px-4 py-3 pr-12 rounded-lg border border-gray-200 focus:outline-none focus:ring-2 focus:border-transparent Accent_color Text_dark"
                     style="--tw-ring-color: <?php echo e($settings['primary_color'] ?? '#16a34a'); ?>;"
                     autocomplete="off"
                    oninput="searchMenu(this.value)">
                <i class="fas fa-search absolute right-4 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
            </div>
        </div>
    </form>

    <!-- Categories -->
    <div class="max-w-4xl mx-auto px-4 mb-6">
        <div class="flex space-x-reverse space-x-2 overflow-x-auto category-scroll pb-2" id="categories-container">
            <!-- Categories will be populated by JavaScript -->
            <button onclick="filterByCategory('all')" class="category-btn px-4 py-2 rounded-full whitespace-nowrap btn-press border-hover primary_color text-white" data-category="all">
                الكل
            </button>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button onclick="filterByCategory('<?php echo e($cat->name); ?>')" class="category-btn px-4 py-2 rounded-full whitespace-nowrap border-hover btn-press Accent_color Text_light border border-gray-200 hover:bg-gray-50" data-category="<?php echo e($cat->name); ?>">
                        <?php echo e($cat->name); ?>

                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <!-- Menu Items -->
    <div id="menu-container">
        <?php echo $__env->make('menu-container', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>

    
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        const menuData = {
            restaurant: {
                name: "<?php echo e($restaurant->name); ?>",
                phone: "<?php echo e($restaurant->phone); ?>",
                /* address: "شارع المثال، القاهرة", */
                rating: 4.6,
                currency: "<?php echo e($restaurant->currency); ?>"
            },
            
        };
        // Share menu
        function shareMenu() {
            if (navigator.share) {
                navigator.share({
                    title: menuData.restaurant.name,
                    text: 'تصفح قائمة طعام ' + menuData.restaurant.name,
                    url: window.location.href
                });
            } else {
                // Fallback: copy to clipboard
                navigator.clipboard.writeText(window.location.href).then(() => {
                    showToast('تم نسخ رابط القائمة');
                });
            }
        }
       // فلترة بالتصنيف
        function filterByCategory(categoryname) {
            // تحديث أزرار التصنيفات
                document.querySelectorAll('.category-btn').forEach(btn => {
                    if (btn.dataset.category === categoryname) {
                        btn.className = 'category-btn px-4 py-2 rounded-full whitespace-nowrap btn-press primary_color text-white border-hover';
                    } else {
                        btn.className = 'category-btn px-4 py-2 rounded-full whitespace-nowrap btn-press Accent_color Text_light border-hover border border-gray-200 hover:bg-gray-50';
                    }
                });

            // استدعاء AJAX بدلاً من renderMenu
            loadMenu(categoryname, document.getElementById('search-input').value);
        }

        // البحث
        function searchMenu(searchTerm) {
            let activeCategory = document.querySelector('.category-btn.primary_color')?.dataset.category || 'all';
            loadMenu(activeCategory, searchTerm);
        }

        // AJAX لتحميل القائمة
        function loadMenu(category = 'all', search = '') {
            $.ajax({
                url: "<?php echo e(route('menu.partial')); ?>", // Laravel route
                method: "GET",
                data: { category: category, search: search },
                success: function(response) {
                    $("#menu-container").html(response); // استبدال المحتوى
                },
                error: function(xhr) {
                    console.error(xhr.responseText);
                }
            });
        }

        // البحث المباشر عند الكتابة
        $("#search-input").on("keyup", function(){
            searchMenu($(this).val());
        });
        
    </script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\menu-test\resources\views/welcome.blade.php ENDPATH**/ ?>