

<?php $__env->startSection('title', 'اضافة عرض جديد'); ?>

<?php $__env->startSection('content'); ?>
<div class="bg-white p-6 rounded shadow max-w-3xl mx-auto">
    <h2 class="text-2xl font-bold mb-6">➕ إضافة عرض جديد</h2>

    <form method="POST" action="<?php echo e(route('offers.store')); ?>" enctype="multipart/form-data" class="space-y-6">
        <?php echo csrf_field(); ?>

        <?php if(session('success')): ?>
            <div class="bg-green-100 text-green-800 px-4 py-2 rounded-lg">
                ✅ <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>
        <?php if($errors->any()): ?>
            <div class="bg-red-100 text-red-800 px-4 py-2 rounded-lg">
                <ul class="list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <!-- العنوان -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">عنوان العرض</label>
            <input type="text" name="title" value="<?php echo e(old('title')); ?>"
                   class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-green-500"
                   placeholder="مثال: عرض الساندوتشات 2+1 مجاناً" required>
            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

        <!-- الوصف -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">الوصف</label>
            <textarea name="description"
                      class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-green-500"
                      rows="4" placeholder="اكتب وصف العرض"><?php echo e(old('description')); ?></textarea>
        </div>

        <!-- السعر -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">السعر (<?php echo e($restaurant->currency); ?>)</label>
            <input type="number" step="0.01" name="price" value="<?php echo e(old('price')); ?>"
                   class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-green-500"
                   placeholder="أدخل السعر" required>
        </div>

        <!-- الصورة -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">صورة العرض</label>
            <input type="file" name="image" accept="image/*"
                   class="w-full border border-gray-300 rounded-lg p-2 bg-gray-50 focus:outline-none focus:ring-2 focus:ring-green-500">
        </div>

        <!-- عرض مميز -->
        <div class="flex items-center space-x-2 space-x-reverse">
            <input type="checkbox" name="is_featured" id="is_featured" class="h-5 w-5 text-green-600" value="1" <?php echo e(old('is_featured') ? 'checked' : ''); ?>>
            <label for="is_featured" class="text-gray-700 font-semibold">عرض مميز 🔥</label>
        </div>

        <!-- زر الحفظ -->
        <div class="text-right">
            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg font-semibold shadow">
                حفظ العرض
            </button>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.nav.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/egysyrne/menu.egysyr.net/2/resources/views/dashboard/add_offer.blade.php ENDPATH**/ ?>