


<?php $__env->startSection('title', 'تحديث الالوان'); ?>

<?php $__env->startSection('content'); ?>
    <div class="max-w-3xl mx-auto bg-white shadow-lg rounded-2xl p-8 mt-10 border border-gray-100">
        <h2 class="text-3xl font-bold mb-8 text-gray-800 flex items-center gap-2">
            <i class="fas fa-palette text-green-600"></i>
            إعدادات الألوان
        </h2>

        <?php if(session('success')): ?>
            <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg mb-6 text-sm flex items-center gap-2">
                <i class="fas fa-check-circle text-green-500"></i>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('settings_colors.update')); ?>" class="space-y-6">
            <?php echo csrf_field(); ?>

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="group relative transition">
                        <label class="block text-sm font-medium text-gray-600 mb-2 tracking-wide">
                            <?php echo e(__('لون ' . str_replace('_', ' ', $key))); ?>

                        </label>
                        <div class="flex items-center gap-3 bg-gray-50 border border-gray-200 rounded-lg p-3 hover:border-green-400 transition">
                            <input 
                                type="color" 
                                name="<?php echo e($key); ?>" 
                                value="<?php echo e($value); ?>" 
                                class="w-12 h-12 rounded-lg cursor-pointer shadow-sm border border-gray-300"
                            >
                            <div class="flex-1">
                                <span class="block text-gray-800 font-semibold text-sm"><?php echo e($value); ?></span>
                                <small class="text-gray-400 text-xs"><?php echo e($key); ?></small>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="pt-6 text-right border-t border-gray-100">
                <button 
                    class="bg-green-600 text-white px-6 py-3 rounded-lg font-medium shadow-md hover:bg-green-700 hover:shadow-lg transition transform hover:-translate-y-0.5 focus:outline-none focus:ring-2 focus:ring-green-500">
                    <i class="fas fa-save ml-2"></i> حفظ التغييرات
                </button>
            </div>
        </form>
    </div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('dashboard.nav.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\menu-test\resources\views/dashboard/setting_colors.blade.php ENDPATH**/ ?>