<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\RestaurantController;
use App\Models\Category;
use App\Http\Controllers\SettingsController;


// Route::get('/', function () {
//     if (!Category::exists()) {
//         return response('لا يوجد اقسام ');
//     }else{
//         $firstCategory = \App\Models\Category::first();
//         return redirect()->route('menu.category', urlencode($firstCategory->name ?? ''));
//     }
// });


Route::get('/', [\App\Http\Controllers\MenuController::class, 'showCategory'])->name('menu.category');
// Route::get('/{category}', [\App\Http\Controllers\MenuController::class, 'showItems'])->name('menu.items');
Route::get('/Settings', [\App\Http\Controllers\DashboardController::class, 'Settings'])->name('settings');

Route::get('/menu/partial', [MenuController::class, 'menuPartial'])->name('menu.partial');


// صفحة تسجيل المطعم
Route::get('/register-restaurant', [RestaurantController::class, 'showRegisterForm'])->name('restaurant.register');
Route::post('/register-restaurant', [RestaurantController::class, 'register'])->name('restaurant.store');


// صفحة الداشبورد
use Illuminate\Support\Facades\Auth;
use App\Models\Restaurant;
use App\Http\Controllers\DashboardController;

Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

// صفحة تسجيل الدخول
// Route::get('/login', function () {
//     return view('auth.login'); // لو عندك صفحة تسجيل دخول مخصصة
// })->name('login');

use App\Http\Controllers\RestaurantAuthController;

Route::get('/login', [RestaurantAuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [RestaurantAuthController::class, 'login'])->name('login.submit');
Route::post('/logout', [RestaurantAuthController::class, 'logout'])->name('logout');


Route::post('/items', [DashboardController::class, 'store'])->name('items.store');
Route::post('/categories', [DashboardController::class, 'categories_store'])->name('categories.store');


Route::get('/add_items', [DashboardController::class, 'add_items'])->name('add_items');
Route::get('/add_categories', [DashboardController::class, 'add_categories'])->name('add_categories');


Route::get('/items/{item}/edit', [DashboardController::class, 'edit'])->name('items.edit');
Route::put('/items/{item}', [DashboardController::class, 'update'])->name('items.update');

Route::get('/categories/{item}/edit', [DashboardController::class, 'categories_edit'])->name('categories.edit');
Route::put('/categories/{item}', [DashboardController::class, 'categories_update'])->name('categories.update');

Route::put('/Settings', [DashboardController::class, 'Settings_update'])->name('settings.update');


Route::delete('/items/{item}', [DashboardController::class, 'destroy'])->name('items.destroy');
Route::delete('/categories/{category}', [DashboardController::class, 'categories_destroy'])->name('categories.destroy');




Route::get('setting_colors', [SettingsController::class, 'index'])->name('settings_colors.index');
Route::post('setting_colors', [SettingsController::class, 'update'])->name('settings_colors.update');


Route::get('/add_Offer', [DashboardController::class, 'create_Offer'])->name('add_offer');
Route::post('/add_Offer', [DashboardController::class, 'store_Offer'])->name('offers.store');

Route::get('/edit_Offer/{offer}', [DashboardController::class, 'edit_Offer'])->name('edit_offer');
Route::put('/edit_Offer/{offer}', [DashboardController::class, 'update_Offer'])->name('offers.update');
Route::delete('/edit_Offer/{offer}', [DashboardController::class, 'destroy_Offer'])->name('offers.delete');