{{-- @foreach($categoriesList as $cat) --}}
    <main class="max-w-4xl mx-auto px-4 pb-24">
        <div id="menu-container">
            <!-- Menu items will be populated by JavaScript -->

            @foreach($categoriesList as $cat)
                @if($items->where('category_id', $cat->id)->count() > 0)
                    <div class="mb-6">
                        <h2 class="text-xl font-bold Text_dark mb-4 border-b border-gray-200 pb-2">
                            {{ $cat->name }}
                        </h2>
                    </div>
                    <div class="grid gap-4 mb-8">
                        @forelse($items as $item)
                            @if($item->category_id == $cat->id)
                            <div class="Accent_color rounded-lg shadow-sm border border-gray-100 overflow-hidden fade-in">
                                <div class="flex">
                                    <div class="flex-1 p-4">
                                        <h3 class="font-semibold Text_dark mb-2">{{ $item->name }}</h3>
                                        <p class="Text_light text-sm mb-3 leading-relaxed">{{ $item->description }}</p>
                                        
                                    </div>
                                    <div class="w-24 h-24 m-4 flex-shrink-0">
                                        <img src="{{ asset('storage/app/public/' . $item->image_url) }}" alt="{{ $item->name }}" class="w-full h-full object-cover rounded-lg loading-placeholder" loading="lazy">
                                    </div>
                                </div>
                                <div class="flex items-center justify-between p-4">
                                    <div class="flex items-center gap-2">
                                        @if($item->priceS > 0 || $item->priceM > 0 || $item->priceL > 0)
                                            @if($item->priceS > 0)
                                                <div class="flex-1 Accent_color border border-gray-200 rounded-lg p-2 text-center border-hover transition">
                                                    <span class="block text-sm Text_light font-medium">صغير</span>
                                                    <span class="block text-green-600 font-bold text-base">{{ $item->priceS }} {{ $restaurant->currency }}</span>
                                                </div>
                                            @endif
                                            @if($item->priceM > 0)
                                                <div class="flex-1 Accent_color border border-gray-200 rounded-lg p-2 text-center border-hover transition">
                                                    <span class="block text-sm Text_light font-medium">وسط</span>
                                                    <span class="block text-green-600 font-bold text-base">{{ $item->priceM }} {{ $restaurant->currency }}</span>
                                                </div>
                                            @endif
                                            @if($item->priceL > 0)
                                                <div class="flex-1 Accent_color border border-gray-200 rounded-lg p-2 text-center border-hover transition">
                                                    <span class="block text-sm Text_light font-medium">كبير</span>
                                                    <span class="block text-green-600 font-bold text-base">{{ $item->priceL }} {{ $restaurant->currency }}</span>
                                                </div>
                                            @endif
                                        @elseif($item->price > 0)
                                            <div class="flex-1 Accent_color border border-gray-200 rounded-lg p-2 text-center border-hover transition">
                                                {{-- <span class="block text-sm Text_light font-medium">كبير</span> --}}
                                                <span class="block text-green-600 font-bold text-base">{{ $item->price }} {{ $restaurant->currency }}</span>
                                            </div>
                                        @endif
                                    </div>
                                    
                                </div>
                            </div>
                            @elseif($item->category_id == $cat->id)
                                {{-- <div id="empty-state" class="text-center py-12">
                                    <i class="fas fa-search text-4xl text-gray-300 mb-4"></i>
                                    <p class="text-gray-500">لم يتم العثور على أصناف مطابقة للبحث</p>
                                </div> --}}
                            @endif
                        @empty
                            {{-- <div id="empty-state" class="text-center py-12">
                                <i class="fas fa-search text-4xl text-gray-300 mb-4"></i>
                                <p class="text-gray-500">لم يتم العثور على أصناف مطابقة للبحث</p>
                            </div> --}}
                        @endforelse
                    </div>
                @endif
            @endforeach
            @if($items->count() <= 0)
                    <div class="text-center py-12">
                        <i class="fas fa-search text-4xl text-gray-300 mb-4"></i>
                        <p class="text-gray-500">لم يتم العثور على أصناف مطابقة للبحث</p>
                    </div>
            @endif
        </div>
        
        <!-- Empty State -->
        {{-- <div id="empty-state" class="hidden text-center py-12">
            <i class="fas fa-search text-4xl text-gray-300 mb-4"></i>
            <p class="text-gray-500">لم يتم العثور على أصناف مطابقة للبحث</p>
        </div> --}}
    </main>
{{-- @endforeach --}}
