
@extends('dashboard.nav.nav')

@section('title', 'تحديث الالوان')

@section('content')
    <div class="max-w-3xl mx-auto bg-white shadow-lg rounded-2xl p-8 mt-10 border border-gray-100">
        <h2 class="text-3xl font-bold mb-8 text-gray-800 flex items-center gap-2">
            <i class="fas fa-palette text-green-600"></i>
            إعدادات الألوان
        </h2>

        @if(session('success'))
            <div class="bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg mb-6 text-sm flex items-center gap-2">
                <i class="fas fa-check-circle text-green-500"></i>
                {{ session('success') }}
            </div>
        @endif

        <form method="POST" action="{{ route('settings_colors.update') }}" class="space-y-6">
            @csrf

            <div class="grid grid-cols-1 sm:grid-cols-2 gap-6">
                @foreach($settings as $key => $value)
                    <div class="group relative transition">
                        <label class="block text-sm font-medium text-gray-600 mb-2 tracking-wide">
                            {{ __('لون ' . str_replace('_', ' ', $key)) }}
                        </label>
                        <div class="flex items-center gap-3 bg-gray-50 border border-gray-200 rounded-lg p-3 hover:border-green-400 transition">
                            <input 
                                type="color" 
                                name="{{ $key }}" 
                                value="{{ $value }}" 
                                class="w-12 h-12 rounded-lg cursor-pointer shadow-sm border border-gray-300"
                            >
                            <div class="flex-1">
                                <span class="block text-gray-800 font-semibold text-sm">{{ $value }}</span>
                                <small class="text-gray-400 text-xs">{{ $key }}</small>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="pt-6 text-right border-t border-gray-100">
                <button 
                    class="bg-green-600 text-white px-6 py-3 rounded-lg font-medium shadow-md hover:bg-green-700 hover:shadow-lg transition transform hover:-translate-y-0.5 focus:outline-none focus:ring-2 focus:ring-green-500">
                    <i class="fas fa-save ml-2"></i> حفظ التغييرات
                </button>
            </div>
        </form>
    </div>

@endsection