@extends('dashboard.nav.nav')

@section('title', 'تعديل القسم')

@section('content')

<div class="max-w-lg mx-auto bg-white shadow-xl rounded-2xl p-8 mt-10 border border-gray-100">
    <h2 class="text-2xl font-bold text-gray-800 mb-6 border-b pb-3 text-center">✏️ تعديل القسم</h2>

    <!-- زر الحذف -->
    <form action="{{ route('categories.destroy', $category->id) }}" method="POST"
          onsubmit="return confirm('هل أنت متأكد من حذف هذا القسم؟');"
          class="text-center mb-6">
        @csrf
        @method('DELETE')
        <button type="submit"
            class="bg-red-500 hover:bg-red-600 text-white px-5 py-2 rounded-lg shadow transition">
            🗑️ حذف القسم
        </button>
    </form>

    <!-- فورم التعديل -->
    <form method="POST" action="{{ route('categories.update', $category->id) }}" class="space-y-5">
        @csrf
        @method('PUT')

        @if (session('success'))
            <div class="bg-green-100 text-green-800 px-4 py-2 rounded-lg">
                ✅ {{ session('success') }}
            </div>
        @endif

        @if ($errors->any())
            <div class="bg-red-100 text-red-800 px-4 py-2 rounded-lg">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- الاسم -->
        <div>
            <label for="name" class="block text-gray-700 font-semibold mb-2">📛 اسم القسم</label>
            <input type="text" name="name" id="name"
                   value="{{ old('name', $category->name) }}"
                   required
                   class="w-full border border-gray-300 rounded-lg px-4 py-2 focus:ring-2 focus:ring-blue-500 focus:border-blue-500">
        </div>

        <!-- زر التحديث -->
        <div class="text-center">
            <button type="submit"
                    class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded-lg shadow transition">
                💾 تحديث القسم
            </button>
        </div>
    </form>
</div>

@endsection