
@extends('dashboard.nav.nav')

@section('title', 'لوحة التحكم')

@section('content')

<!-- Floating Toast Container -->
<div id="toast-root" class="fixed inset-0 flex items-start px-4 py-6 pointer-events-none z-50">
    <div class="w-full flex flex-col items-center space-y-4 sm:items-end">
        <!-- Toast template will be injected here -->
        @if(session('success') || session('error') || session('info'))
            @php
                if(session('success')) { $type='success'; $msg = session('success'); }
                elseif(session('error')) { $type='error'; $msg = session('error'); }
                else { $type='info'; $msg = session('info'); }
            @endphp

            <div x-data x-init="showToastManual()" id="blade-session-toast"
                 class="pointer-events-auto max-w-sm w-full overflow-hidden rounded-lg shadow-lg transform transition-all"
                 role="status" aria-live="polite"
                 data-type="{{ $type }}" data-message="{{ $msg }}">
                <!-- template will be styled/handled by JS below -->
            </div>
        @endif
    </div>
</div>


<div class="min-h-screen bg-gray-100 py-10 px-6">
    <div class="max-w-6xl mx-auto bg-white rounded-2xl shadow-lg p-8">

        <h2 class="text-3xl font-bold text-gray-800 mb-8 border-b pb-4 text-center">
            ⚙️ لوحة التحكم
        </h2>

        {{-- الأقسام --}}
        <div class="mb-10">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-xl font-semibold text-gray-700">📂 الأقسام</h3>
                <a href="{{ route('add_categories') }}" class="bg-blue-600 text-white px-4 py-2 rounded-lg shadow hover:bg-blue-700 transition">
                    + إضافة قسم جديد
                </a>
            </div>

            @if($categories->count() > 0)
                <ul class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-4">
                    @foreach($categories as $category)
                        <li class="bg-gray-50 border rounded-lg p-4 text-center hover:bg-blue-50 transition">
                            <a href="{{ route('categories.edit', $category->id) }}" class="text-gray-800 font-medium hover:text-blue-600">
                                {{ $category->name }}
                            </a>
                        </li>
                    @endforeach
                </ul>
            @else
                <p class="text-gray-500 mt-2">لا توجد أقسام حالياً.</p>
            @endif
        </div>

        {{-- الأصناف --}}
        <div class="mb-10">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-xl font-semibold text-gray-700">🍽️ الأصناف</h3>
                <a href="{{ route('add_items') }}" class="bg-green-600 text-white px-4 py-2 rounded-lg shadow hover:bg-green-700 transition">
                    + إضافة صنف جديد
                </a>
            </div>

            @if($items->count() > 0)
                <div class="overflow-x-auto">
                    <table class="min-w-full border-collapse bg-white">
                        <thead>
                            <tr class="bg-gray-100 border-b">
                                <th class="py-3 px-4 text-gray-700 text-right font-semibold">الاسم</th>
                                <th class="py-3 px-4 text-gray-700 text-right font-semibold">السعر</th>
                                <th class="py-3 px-4 text-gray-700 text-right font-semibold">السعر صغير</th>
                                <th class="py-3 px-4 text-gray-700 text-right font-semibold">السعر وسط</th>
                                <th class="py-3 px-4 text-gray-700 text-right font-semibold">السعر كبير</th>
                                <th class="py-3 px-4 text-gray-700 text-right font-semibold">القسم</th>
                                <th class="py-3 px-4 text-gray-700 text-right font-semibold">إجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($items as $item)
                                <tr class="border-b hover:bg-gray-50 transition">
                                    <td class="py-3 px-4 text-gray-800">{{ $item->name }}</td>
                                    <td class="py-3 px-4 text-gray-600">{{ $item->price ?? '-' }}</td>
                                    <td class="py-3 px-4 text-gray-600">{{ $item->priceS ?? '-' }}</td>
                                    <td class="py-3 px-4 text-gray-600">{{ $item->priceM ?? '-' }}</td>
                                    <td class="py-3 px-4 text-gray-600">{{ $item->priceL ?? '-' }}</td>
                                    <td class="py-3 px-4 text-gray-800">{{ $item->category->name ?? 'بدون قسم' }}</td>
                                    <td class="py-3 px-4 flex gap-2">
                                        <a href="{{ route('items.edit', $item->id) }}" class="text-blue-600 hover:underline">تعديل</a>
                                        <form action="{{ route('items.destroy', $item->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذا المنتج؟');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="text-red-600 hover:underline">حذف</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <p class="text-gray-500 mt-2">لا توجد أصناف حالياً.</p>
            @endif
        </div>

        {{-- العروض --}}
        <div>
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-xl font-semibold text-gray-700">🎁 العروض</h3>
                <a href="{{ route('add_offer') }}" class="bg-purple-600 text-white px-4 py-2 rounded-lg shadow hover:bg-purple-700 transition">
                    + إضافة عرض جديد
                </a>
            </div>

            @if($offers->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    @foreach($offers as $offer)
                        <div class="bg-gray-50 border rounded-xl p-5 shadow hover:shadow-md transition">
                            <h4 class="text-lg font-semibold text-gray-800 mb-2">{{ $offer->title }}</h4>
                            <p class="text-gray-600 mb-3">{{ Str::limit($offer->description, 80) }}</p>
                            <div class="text-gray-700 mb-3">
                                <span class="font-medium">السعر:</span> {{ $offer->price }} {{ $restaurant->currency ?? 'جنيه' }}
                            </div>
                            @if($offer->image)
                                <img src="{{ asset('storage/' . $offer->image) }}" alt="Offer Image" class="rounded-lg w-full h-40 object-cover mb-3">
                            @endif
                            <div class="flex gap-3">
                                <a href="{{ route('edit_offer', $offer->id) }}" class="text-blue-600 hover:underline">تعديل</a>
                                <form action="{{ route('offers.delete', $offer->id) }}" method="POST" onsubmit="return confirm('هل أنت متأكد من حذف هذا العرض؟');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="text-red-600 hover:underline">حذف</button>
                                </form>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-gray-500 mt-2">لا توجد عروض حالياً.</p>
            @endif
        </div>

    </div>
</div>


<script>
(function(){
  // Helper: create toast element
  function createToast(message, type = 'info', opts = {}) {
    const duration = opts.duration ?? 5000; // ms
    const root = document.querySelector('#toast-root .flex-col');

    const colors = {
      success: { bg: 'bg-emerald-50', border: 'border-emerald-200', ring: 'ring-emerald-500', text: 'text-emerald-800', icon: '✔' },
      error:   { bg: 'bg-red-50', border: 'border-red-200', ring: 'ring-red-500', text: 'text-red-800', icon: '✖' },
      info:    { bg: 'bg-blue-50', border: 'border-blue-200', ring: 'ring-blue-500', text: 'text-blue-800', icon: 'ℹ' },
    };

    const cfg = colors[type] ?? colors.info;

    // element
    const toast = document.createElement('div');
    toast.className = `pointer-events-auto w-full max-w-sm rounded-lg shadow-lg transform transition-all duration-300 translate-y-2 opacity-0`;
    toast.setAttribute('role','status');
    toast.setAttribute('aria-live','polite');

    toast.innerHTML = `
      <div class="${cfg.bg} border ${cfg.border} p-3 rounded-lg flex items-start gap-3">
        <div class="flex-shrink-0 mt-0.5">
          <div class="h-8 w-8 flex items-center justify-center rounded-full text-sm ${cfg.text} bg-white/60 font-bold">${cfg.icon}</div>
        </div>
        <div class="flex-1">
          <p class="text-sm ${cfg.text} leading-tight">${message}</p>
        </div>
        <div class="flex-shrink-0">
          <button type="button" aria-label="Close notification" class="toast-close-btn inline-flex p-1 rounded-md hover:bg-white/40 focus:outline-none focus:ring-2 focus:ring-offset-1 ${cfg.ring}">
            <svg class="h-4 w-4 ${cfg.text}" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M6.72 6.72a.75.75 0 011.06 0L10 8.94l2.22-2.22a.75.75 0 111.06 1.06L11.06 10l2.22 2.22a.75.75 0 11-1.06 1.06L10 11.06l-2.22 2.22a.75.75 0 11-1.06-1.06L8.94 10 6.72 7.78a.75.75 0 010-1.06z" clip-rule="evenodd"/></svg>
          </button>
        </div>
      </div>
    `;

    // append and animate in
    root.prepend(toast);
    // force reflow to allow transition
    requestAnimationFrame(()=> {
      toast.classList.remove('opacity-0','translate-y-2');
      toast.classList.add('opacity-100','translate-y-0');
    });

    // close handler
    const closeBtn = toast.querySelector('.toast-close-btn');
    const removeToast = () => {
      toast.classList.add('opacity-0','translate-y-2');
      setTimeout(()=> toast.remove(), 300);
      if (timer) clearTimeout(timer);
    };
    closeBtn.addEventListener('click', removeToast);

    // auto dismiss
    let timer = setTimeout(removeToast, duration);

    // pause on hover
    toast.addEventListener('mouseenter', () => clearTimeout(timer));
    toast.addEventListener('mouseleave', () => timer = setTimeout(removeToast, duration));

    return toast;
  }

  // If there's a Blade session toast placeholder, use it:
  document.addEventListener('DOMContentLoaded', function() {
    const bladeToast = document.getElementById('blade-session-toast');
    if (bladeToast) {
      const type = bladeToast.dataset.type || 'info';
      const msg = bladeToast.dataset.message || '';
      createToast(msg, type, { duration: 5000 });
      bladeToast.remove(); // placeholder not needed
    }
  });

  // Expose a global helper to create toasts from anywhere
  window.showToast = function(message, type='info', duration=5000) {
    return createToast(message, type, { duration });
  };
})();
</script>

@endsection


