@extends('dashboard.nav.nav')

@section('title', 'اضافة عرض جديد')

@section('content')
<div class="bg-white p-6 rounded shadow max-w-3xl mx-auto">
    <h2 class="text-2xl font-bold mb-6">➕ إضافة عرض جديد</h2>

    <form method="POST" action="{{ route('offers.store') }}" enctype="multipart/form-data" class="space-y-6">
        @csrf

        @if (session('success'))
            <div class="bg-green-100 text-green-800 px-4 py-2 rounded-lg">
                ✅ {{ session('success') }}
            </div>
        @endif
        @if ($errors->any())
            <div class="bg-red-100 text-red-800 px-4 py-2 rounded-lg">
                <ul class="list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <!-- العنوان -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">عنوان العرض</label>
            <input type="text" name="title" value="{{ old('title') }}"
                   class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-green-500"
                   placeholder="مثال: عرض الساندوتشات 2+1 مجاناً" required>
            @error('title') <p class="text-red-600 text-sm mt-1">{{ $message }}</p> @enderror
        </div>

        <!-- الوصف -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">الوصف</label>
            <textarea name="description"
                      class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-green-500"
                      rows="4" placeholder="اكتب وصف العرض">{{ old('description') }}</textarea>
        </div>

        <!-- السعر -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">السعر ({{ $restaurant->currency }})</label>
            <input type="number" step="0.01" name="price" value="{{ old('price') }}"
                   class="w-full border border-gray-300 rounded-lg p-3 focus:outline-none focus:ring-2 focus:ring-green-500"
                   placeholder="أدخل السعر" required>
        </div>

        <!-- الصورة -->
        <div>
            <label class="block text-gray-700 font-semibold mb-2">صورة العرض</label>
            <input type="file" name="image" accept="image/*"
                   class="w-full border border-gray-300 rounded-lg p-2 bg-gray-50 focus:outline-none focus:ring-2 focus:ring-green-500">
        </div>

        <!-- عرض مميز -->
        <div class="flex items-center space-x-2 space-x-reverse">
            <input type="checkbox" name="is_featured" id="is_featured" class="h-5 w-5 text-green-600" value="1" {{ old('is_featured') ? 'checked' : '' }}>
            <label for="is_featured" class="text-gray-700 font-semibold">عرض مميز 🔥</label>
        </div>

        <!-- زر الحفظ -->
        <div class="text-right">
            <button type="submit" class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded-lg font-semibold shadow">
                حفظ العرض
            </button>
        </div>
    </form>
</div>
@endsection
